#include <xc.h>
#include "main_header.h"

void Update_Dimming_State(void)
{
    Dimming_State = Dimming_State + 1;
    if (Dimming_State == 4)
    {
        Dimming_State = 0;
    }
    switch(Dimming_State)
    {
        case STATE0:
            PE1 = PDRV_SDRV_OFF;
            T2CONbits.TMR2ON = 0;
            PR2 = SSP_PR2;
            PWMRL = SSP_PWMR;
            PWMRH = SSP_PWMR;
            if (!SSP_ENABLEbits.FF_QRn)
            {
                DESATCON = DESATCON_QR;
            }
            PE1 = PDRV_ON;
            T2CONbits.TMR2ON = 1;
            ABECONbits.EADIS = 0;
            _delay(100);
            if (SSP_ENABLEbits.SYNC_ASYNCn)
            {
                PE1 = PDRV_SDRV_ON;
            }
            if(Blink_Count > 127)
            {
                CC2RH = CC2RH + BLINK_STATE0;
            }
            else
            {
                CC2RH = CC2RH + SSP_STATE0;
            }
            if(Operating_State == DRL_ON)
            {
                CCDCON = 0;
                PIE1bits.CC2IE = 0;
                T1CONbits.TMR1ON = 0;
                CC2RL = 0;
                CC2RH = 0;
                TMR1H = 0;
                TMR1L = 0;
            }
            break;
        case STATE1:
            PE1 = PDRV_SDRV_OFF;
            ABECONbits.EADIS = 1;
            T2CONbits.TMR2ON = 0;
            VREFCON = SSP_VREFCON2;
            DESATCON = DESATCON_FF;
            OVREFCON = REPO_SIG;
            PR2 = REPO_PWM;
            PWMRL = REPO_DC;
            PWMRH = REPO_DC;
            _delay(10);
            T2CONbits.TMR2ON = 1;
            OPTION_REGbits.PS = PS512uS;
            PIR2bits.OVIF = 0;
            OVCONbits.OVINTN = 1;
            TMR0 = 0;
            INTCONbits.T0IF = 0;
            PE1 = STR_SDRV;
            while(!PIR2bits.OVIF && !INTCONbits.T0IF);
            PE1 = PDRV_SDRV_OFF;
            T2CONbits.TMR2ON = 0;
            OVCONbits.OVINTN = 0;
            PIR2bits.OVIF = 0;
            OVREFCON = SSP_OVREFCON;
            PWMRL = DIM_DC;
            PWMRH = DIM_DC;
            PORTGPA = PORTGPA & 0xFC;
            PORTGPAbits.GPA1 = 1;       // SIG On  - SW2
            PORTGPAbits.GPA3 = 0;       // DRL Off - SW1
            _delay(10);
            T2CONbits.TMR2ON = 1;
            PE1 = STR_PDRV;
            if(Blink_Count > 127)
            {
                CC2RH = CC2RH + BLINK_STATE1;
            }
            else
            {
                CC2RH = CC2RH + SSP_STATE1;
            }
            break;
        case STATE2:
            PE1 = PDRV_SDRV_OFF;
            T2CONbits.TMR2ON = 0;
            PR2 = SSP_PR2;
            PWMRL = SSP_PWMR;
            PWMRH = SSP_PWMR;
            if (!SSP_ENABLEbits.FF_QRn)
            {
                DESATCON = DESATCON_QR;
            }
            PE1 = PDRV_ON;
            T2CONbits.TMR2ON = 1;
            ABECONbits.EADIS = 0;
            _delay(100);
            if (SSP_ENABLEbits.SYNC_ASYNCn)
            {
                PE1 = PDRV_SDRV_ON;
            }
            if(Blink_Count > 127)
            {
                CC2RH = CC2RH + BLINK_STATE2;
            }
            else
            {
                CC2RH = CC2RH + SSP_STATE2;
            }
            if(Operating_State == SIG_ON)
            {
                CCDCON = 0;
                PIE1bits.CC2IE = 0;
                T1CONbits.TMR1ON = 0;
                CC2RL = 0;
                CC2RH = 0;
                TMR1H = 0;
                TMR1L = 0;
                PIR1bits.TMR1IF = 0;
            }
            break;
        case STATE3:
            PE1 = PDRV_SDRV_OFF;
            ABECONbits.EADIS = 1;
            T2CONbits.TMR2ON = 0;
            VREFCON = SSP_VREFCON1;
            DESATCON = DESATCON_FF;
            OVREFCON = REPO_DRL;
            PR2 = REPO_PWM;
            PWMRL = REPO_DC;
            PWMRH = REPO_DC;
            PORTGPA = PORTGPA & 0xFC;
            PORTGPAbits.GPA1 = 0;       // SIG Off - SW2
            PORTGPAbits.GPA3 = 1;       // DRL On  - SW1
            _delay(10);
            T2CONbits.TMR2ON = 1;
            OPTION_REGbits.PS = PS512uS;
            PIR2bits.OVIF = 0;
            OVCONbits.OVINTP = 1;
            TMR0 = 0;
            INTCONbits.T0IF = 0;
            PE1 = STR_PDRV;
            while(!PIR2bits.OVIF && !INTCONbits.T0IF);
            PE1 = PDRV_SDRV_OFF;
            T2CONbits.TMR2ON = 0;
            OVCONbits.OVINTP = 0;
            PIR2bits.OVIF = 0;
            OVREFCON = SSP_OVREFCON;
            PWMRL = DIM_DC;
            PWMRH = DIM_DC;
            _delay(10);
            T2CONbits.TMR2ON = 1;
            PE1 = STR_PDRV;
            if(Blink_Count > 127)
            {
                CC2RH = CC2RH + BLINK_STATE3;
            }
            else
            {
                CC2RH = CC2RH + SSP_STATE3;
            }
            break;
        default:
            Dimming_State = 0;
            break;
    }
}

